# randcoords.R
# Generate random sampling coordinates

# Load necessary libraries
library(ggplot2)

# Generate n random coordinates along a c m transect
# Sample size n
n <- 20
# Uniform random variable with a=0, b=c
c <- 100
x <- runif(n,0,c)

# Print results
x

# Generate n random coordinates within a 200 x 100 m area
n <- 200
c_x <- 200
c_y <- 100
x <- runif(n,0,c_x)
y <- runif(n,0,c_y)

# Make data frame for ggplot2
xydata <- as.data.frame(cbind(x,y))

# Print first 25 coordinates
xydata[1:25,]

# Plot the values
ggplot(xydata,aes(x,y))+
geom_point(color="red",size=3)+
ggtitle("Random sampling coordinates for rectangle")
